﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace SWAT_Office_App
{
    public partial class Reimage_USB_Drive_Progress_Form : Form
    {
        
        private static Reimage_USB_Drive_Progress_Form _Reimage_USB_Drive_Progress_Form = null;
        // Singleton instance
        public static Reimage_USB_Drive_Progress_Form Reimage_USB_Drive_Progress_Form_Instance
        {
            set
            {
                _Reimage_USB_Drive_Progress_Form = value;
            }
            get
            {
                if (_Reimage_USB_Drive_Progress_Form == null)
                    _Reimage_USB_Drive_Progress_Form = new Reimage_USB_Drive_Progress_Form();
                return _Reimage_USB_Drive_Progress_Form;
            }
        }
        public Reimage_USB_Drive_Progress_Form()
        {
            InitializeComponent();
            btn_Cancel.Text = "Cancel";
            this.updateStatus("Beginning the Reimaging of USB Drives");
        }
        private void btn_Cancel_Click(object sender, EventArgs e)
        {
            Reimage_USB_Drives.bwThread.CancelAsync();
            foreach (BackgroundWorker bw in Reimage_USB_Drives.backgroundWorkerList)
                bw.CancelAsync();
            btn_Cancel.Text = "Cancellation Pending";
        }
        delegate void updateStatus_(string parameter);
        public void updateStatus(string status)
        {
            try
            {
                if (!InvokeRequired)
                {
                    lbl_Status.Text = status;
                }
                else
                    Invoke(new updateStatus_(updateStatus), new object[] { status });
            }
            catch (Exception e)
            {
                //MessageBox.Show(e.ToString(), "Error");
                Debug.appendText(e.ToString());
                MessageBox.Show("An error has occured. Please notify a supervisor to debug.", "Error");
            }
        }
        delegate void closeForm_();
        public void closeForm()
        {
            try
            {
                if (!InvokeRequired)
                {
                    this.Close();
                }
                else
                    Invoke(new closeForm_(closeForm), new object[] { });
            }
            catch (Exception e)
            {
                //MessageBox.Show(e.ToString(), "Error");
                Debug.appendText(e.ToString());
                MessageBox.Show("An error has occured. Please notify a supervisor to debug.", "Error");
            }
        }
    }
}
